package easik.sketch.util.Export.Text;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.util.Export.ExportConstants;
import easik.sketch.util.Export.ExportHandler;

/**
 * Class to generate a SQL text file for exportation by the user.  
 * Deals only with fileIO and no formatting of SQL strings.
 * 
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @since 2006-05-16 Vera Ranieri
 * @version 2006-08-03 Kevin Green
 */
public class SQLFileBuilder {
	/**
	 * The file selected by the user to save the text file to
	 */
	private File _selFile;
	/**
	 * The RandomAccessFile used to access the file
	 */
	private RandomAccessFile _raf;
	
	/**
	 * Create a new SQLFileBuilder from the current sketch.  Generates a new file specified by the user
	 * containing SQL code.  
	 * @param sh The ExportHandler used to build the information from the XML file
	 */
	public SQLFileBuilder(ExportHandler sh){
		
		JFileChooser makeDialog = new JFileChooser(Easik.getInstance().getIni().getDefaultFolder());
		makeDialog.addChoosableFileFilter( new SQLFileFilter() );
		makeDialog.showSaveDialog(Easik.getInstance().getFrame());
		_selFile = makeDialog.getSelectedFile();
		if(_selFile != null){
			if(createFile()){
				if(openFile()){
					String name = JOptionPane.showInputDialog("Enter the name of the database");
					if(name !=null){
						new TextBuilder(this, sh,  name);
						if(closeFile())
							JOptionPane.showMessageDialog(null, "File successfully created", 
									"Success", JOptionPane.INFORMATION_MESSAGE);
						else
							JOptionPane.showMessageDialog(null, "Error closing file", 
									"Failure", JOptionPane.ERROR_MESSAGE);
					}
					else{
						_selFile.delete();
						JOptionPane.showMessageDialog(null, "File not Created","Creation Cancelled",
								JOptionPane.INFORMATION_MESSAGE);
					}
				}
				else{
					JOptionPane.showMessageDialog(null, "File was not successfully created", "Failure", JOptionPane.ERROR_MESSAGE);
				}
			}
			else{
				JOptionPane.showMessageDialog(null, "File not Created", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
		
	}
	
	/**
	 * Class to create a new file with the provided name.
	 * 
	 * @return true if file was created, false otherwise
	 */
	private boolean createFile(){
		
		if(!_selFile.getName().endsWith(ExportConstants.SQL_EXTENSION)){
			String newName = _selFile.getAbsolutePath() + ExportConstants.SQL_EXTENSION;
			_selFile.delete();
			_selFile = new File(newName);
		}
		
		try {
			
			if(!_selFile.createNewFile())
			{
				int choice = JOptionPane.showConfirmDialog(null, 
						"A file with this name already exists and will be overwritten. Continue anyway?", 
						"Warning", JOptionPane.WARNING_MESSAGE);
				if(choice == JOptionPane.CANCEL_OPTION)
					return false;
			}
			return true;
			
		} catch (IOException e) {
			return false;
		}
	}
	
	/**
	 * Opens newly created file for reading/writing.
	 * 
	 * @return true if file was successfully opened, false otherwise
	 */
	private boolean openFile(){
		try{
			_raf = new RandomAccessFile(_selFile, "rw");
			return true;
		}
		catch(Exception e){
			return false;
		}
		
	}
	
	/**
	 * Appends a string to the end of a file, as a sequence of 2-byte characters, high byte first.
	 * 
	 * @param s The string that is to be written to the file.
	 * @return True if successfully written, false otherwise.
	 */
	public boolean writeToFile(String s){
		try {
			//SHOULD THIS BE writeUTF(s)???
			_raf.writeBytes(s);
			return true;
		} catch (IOException e) {
			return false;
		}
	}
	
	/**
	 * Closes the currently open file
	 * 
	 * @return True if file successfully closed, false otherwise
	 */
	private boolean closeFile(){
		try {
			_raf.close();
			return true;
		} catch (IOException e) {
			return false;
		}
	}
}
